#light

#r @"SdlSimple.dll"

open System
open Seq
open SdlSimple

let permutations x y = seq {
   for i in x do
      for j in y do
         yield (i, j)
}

//________________________________________________________________________________
SdlSimpleSetup 800 480 16 false

let printallevents e = 
   match e with 
   | KeyDown x -> printf "%d key pressed. (it is a %s)\n" x (scancodeToKey x)
   | KeyUp x -> printf "%d key released.\n" x
   | MouseDown x -> printf "mouse button %d pressed.\n" x
   | MouseUp x -> printf "mouse button %d released.\n" x
   | MouseMove (x, y) -> printf "mouse at coordinates %d, %d.\n" x y
   | JoyButtonDown1 x -> printf "joystick button %d pressed.\n" x
   | JoyButtonUp1 x -> printf "joystick button %d released.\n" x
   | JoyAxis1 (x, y) -> printf "joystick axis %d at position %d.\n" x y
   | _ -> printf "an unknown event occured.\n"

events |> Event.listen printallevents

let mutable switcher = 0
events |> Event.listen (fun x -> match x with KeyDown 49 -> switcher <- (switcher + 1) % 2 | _ -> ())

let somepixels = permutations [50..280] [10..280] |> Seq.to_array
draw {
   let rand = Random()
   match switcher with
   | 0 -> somepixels |> Array.iter (fun c -> pixel (rand.Next()) c)
   | 1 -> somepixels |> Array.iter ( pixel (colour (rand.Next()) (rand.Next()) (rand.Next())) )
   | _ -> failwith "oops."
}

let robot = store "robot256.pcx"
let robot2 = store360 "robot256.pcx"
let mutable angle = 0.0

drawn "robots" {
   (50,10) |> (display robot)
   display360 robot2 (int angle) (400, 0)
   writey angle (650, 150)
   angle <- (angle + 0.4)
}
onevent (KeyDown 50) { cls "robots" }

let random = Random()
drawfire (Draw ("lines", (fun () ->
   rectangle (colour 50 50 50) (400, 200) (800, 480)
   [1..100] |> map (fun x -> 400 + random.Next() % 400, 200 + random.Next() % 280) |> reduce (line (colour 0 255 0)) |> ignore
)))

let _ = Console.ReadLine()
cls()
